/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Build.Reader;

import Zenoph.Notify.Build.Reader.MessageDestinationsReader;
import Zenoph.Notify.Collections.MessageDestinationsList;
import Zenoph.Notify.Report.MessageReport;
import Zenoph.Notify.Store.MessageDestination;
import Zenoph.Notify.Utils.MessageUtil;
import Zenoph.Notify.Utils.RequestUtil;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class MessageReportReader {
    private boolean _done = false;
    private XMLStreamReader _xmlReader = null;
    private String _xmlData;

    public void setData(Object data) throws Exception {
        if (data == null || !(data instanceof String)) {
            throw new Exception("Invalid data for reading message report.");
        }
        String fragment = (String)data;
        this.validateXMLFragment(fragment);
        this._xmlData = fragment;
        ByteArrayInputStream is = new ByteArrayInputStream(fragment.getBytes(RequestUtil.DEFAULT_TEXT_ENCODING));
        XMLInputFactory xif = XMLInputFactory.newInstance();
        this._xmlReader = xif.createXMLStreamReader(is);
    }

    public MessageReport getNextReport() throws Exception {
        if (this._xmlReader == null) {
            throw new Exception("Invalid object reference for creating message report item.");
        }
        while (this._xmlReader.hasNext() && !this._done) {
            int eventType = this._xmlReader.next();
            switch (eventType) {
                case 1: {
                    if (!this._xmlReader.getLocalName().equalsIgnoreCase("message")) break;
                    return this.readMessageReport(this._xmlReader);
                }
                case 2: {
                    if (!this._xmlReader.getLocalName().equalsIgnoreCase("messages")) break;
                    this._done = true;
                }
            }
        }
        return null;
    }

    private MessageReport readMessageReport(XMLStreamReader reader) throws Exception {
        boolean readEnded = false;
        MessageReport report = null;
        if (reader.getLocalName().equalsIgnoreCase("data")) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            while (reader.hasNext() && !readEnded) {
                int eventType = reader.next();
                switch (eventType) {
                    case 1: {
                        String nodeName = reader.getLocalName();
                        if (nodeName.equalsIgnoreCase("batch")) {
                            hm.put("batch", reader.getElementText());
                            break;
                        }
                        if (nodeName.equalsIgnoreCase("category")) {
                            hm.put("category", (Object)MessageUtil.messageCategoryToEnum(reader.getElementText()));
                            break;
                        }
                        if (nodeName.equalsIgnoreCase("text")) {
                            hm.put("text", reader.getElementText());
                            break;
                        }
                        if (nodeName.equalsIgnoreCase("type")) {
                            hm.put("type", Integer.parseInt(reader.getElementText()));
                            break;
                        }
                        if (nodeName.equalsIgnoreCase("sender")) {
                            hm.put("sender", reader.getElementText());
                            break;
                        }
                        if (nodeName.equalsIgnoreCase("personalised")) {
                            hm.put("personalised", reader.getElementText().equalsIgnoreCase("true"));
                            break;
                        }
                        if (nodeName.equalsIgnoreCase("delivery")) {
                            hm.put("delivery", reader.getElementText().equalsIgnoreCase("true"));
                            break;
                        }
                        if (nodeName.equalsIgnoreCase("destinationscount")) {
                            int destsCount = Integer.parseInt(reader.getElementText());
                            hm.put("destsCount", destsCount);
                            break;
                        }
                        if (!nodeName.equalsIgnoreCase("destinations")) break;
                        MessageDestinationsList destsList = this.readMessageDestinations(reader);
                        hm.put("destinations", destsList);
                        break;
                    }
                    case 2: {
                        if (!reader.getLocalName().equalsIgnoreCase("data")) break;
                        readEnded = true;
                    }
                }
            }
            if (hm.size() > 0) {
                report = MessageUtil.createReport(hm);
            }
        }
        return report;
    }

    private MessageDestinationsList readMessageDestinations(XMLStreamReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("destinations")) {
            MessageDestination msgDest;
            MessageDestinationsList destsList = new MessageDestinationsList();
            MessageDestinationsReader destsReader = new MessageDestinationsReader();
            destsReader.setData(reader);
            while ((msgDest = destsReader.getNextItem()) != null) {
                destsList.add(msgDest);
            }
            return destsList;
        }
        return null;
    }

    private void validateXMLFragment(String fragment) throws Exception {
    }

    public MessageReport read() throws Exception {
        if (this._xmlReader == null) {
            throw new Exception("Invalid object reference for creating message report item.");
        }
        while (this._xmlReader.hasNext() && !this._done) {
            int eventType = this._xmlReader.next();
            switch (eventType) {
                case 1: {
                    if (!this._xmlReader.getLocalName().equalsIgnoreCase("data")) break;
                    return this.readMessageReport(this._xmlReader);
                }
                case 2: {
                    if (!this._xmlReader.getLocalName().equalsIgnoreCase("data")) break;
                    this._done = true;
                }
            }
        }
        return null;
    }
}

