/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Build.Writer;

import Zenoph.Notify.Build.Writer.IDataWriter;
import Zenoph.Notify.Build.Writer.MultiPartDataWriter;
import Zenoph.Notify.Build.Writer.UrlEncodedDataWriter;
import Zenoph.Notify.Build.Writer.XmlDataWriter;
import Zenoph.Notify.Compose.Composer;
import Zenoph.Notify.Compose.MessageComposer;
import Zenoph.Notify.Enums.AuthModel;
import Zenoph.Notify.Enums.ContentType;
import Zenoph.Notify.Utils.MessageUtil;
import Zenoph.Notify.Utils.RequestUtil;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public abstract class DataWriter
implements IDataWriter {
    protected AuthModel _authModel;
    protected String _authApiKey;
    protected String _authLogin;
    protected String _authPassword;
    protected boolean _authLoadAPS;

    protected abstract void writeScheduleInfo(Date var1, String var2, Object var3) throws Exception;

    protected abstract void writeCallbackInfo(String var1, ContentType var2, Object var3) throws Exception;

    protected abstract void writeDestinations(Composer var1, Object var2) throws Exception;

    protected abstract void writeCommonMessageProperties(MessageComposer var1, Object var2) throws Exception;

    public static DataWriter create(ContentType contentType) throws Exception {
        if (null == contentType) {
            throw new Exception("Invalid or unsupported content type for initialising request data writer.");
        }
        switch (contentType) {
            case XML: 
            case GZBIN_XML: {
                return new XmlDataWriter();
            }
            case WWW_URL_ENCODED: 
            case GZBIN_WWW_URL_ENCODED: {
                return new UrlEncodedDataWriter();
            }
            case MULTIPART_FORM_DATA: {
                return new MultiPartDataWriter();
            }
        }
        throw new Exception("Invalid or unsupported content type for initialising request data writer.");
    }

    public void setAuthModel(AuthModel model) {
        this._authModel = model;
    }

    public void setAuthApiKey(String apiKey) throws Exception {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new Exception("Invalid API key for writing authentication data.");
        }
        this._authApiKey = apiKey;
    }

    public void setAuthLogin(String login) throws Exception {
        if (login == null || login.isEmpty()) {
            throw new Exception("Invalid login for writing authentication data.");
        }
        this._authLogin = login;
    }

    public void setAuthPassword(String psswd) throws Exception {
        if (psswd == null || psswd.isEmpty()) {
            throw new Exception("Invalid password for writing authentication data.");
        }
        this._authPassword = psswd;
    }

    public void setAuthAPSLoad(boolean load) throws Exception {
        this._authLoadAPS = load;
    }

    protected void assertAuthData() throws Exception {
        if (this._authModel != AuthModel.API_KEY && this._authModel != AuthModel.PORTAL_PASS) {
            throw new Exception("Authentication model has not been set for writing request.");
        }
        if (this._authModel == AuthModel.PORTAL_PASS) {
            if (this._authLogin == null || this._authLogin.isEmpty()) {
                throw new Exception("Account login has not been set for writing request.");
            }
            if (this._authPassword == null || this._authPassword.isEmpty()) {
                throw new Exception("Account password has not been set for writing request.");
            }
        } else if (this._authApiKey == null || this._authApiKey.isEmpty()) {
            throw new Exception("API key has not been set for writing request.");
        }
    }

    protected void validateScheduleInfo(Date dateTime, String utcOffset) throws Exception {
        if (dateTime == null) {
            throw new Exception("Invalid DateTime object for writing message scheduling information.");
        }
        if (utcOffset != null && !utcOffset.isEmpty() && !MessageUtil.isValidTimeZoneUTCOffset(utcOffset)) {
            throw new Exception("Invalid time zone UTC offset specifier.");
        }
    }

    protected void validateDeliveryNotificationInfo(String url, ContentType contentType) throws Exception {
        if (url == null || url.isEmpty()) {
            throw new Exception("Invalid URL for message delivery notifications.");
        }
        if (contentType != ContentType.XML && contentType != ContentType.JSON) {
            throw new Exception("Unsupported content type for message delivery notifications.");
        }
    }

    protected void validateScheduledMessagesLoadData(HashMap<String, Object> data) throws Exception {
        if (data == null || data.isEmpty()) {
            throw new Exception("Invalid object for writing scheduled messages request data.");
        }
        if (!data.containsKey("category")) {
            throw new Exception("Message category parameter has not been set for writing scheduled messages request data.");
        }
        if (!data.containsKey("dateFrom")) {
            throw new Exception("Date 'From' parameter has not been set for writing scheduled messages request data.");
        }
        if (!data.containsKey("dateTo")) {
            throw new Exception("Date 'To' parameter has not been set for writing scheduled messages request data.");
        }
        if (!data.containsKey("offset")) {
            throw new Exception("Time zone UTC offset parameter has not been set for writing scheduled messages request data.");
        }
        if (!data.containsKey("batch")) {
            throw new Exception("Message batch identifier has not been set.");
        }
    }

    protected String dateTimeToStr(Date dateTime) {
        SimpleDateFormat sdf = new SimpleDateFormat(RequestUtil.DATE_TIME_FORMAT);
        return sdf.format(dateTime);
    }

    protected void writeRequestData(String requestStr, OutputStream os) throws Exception {
        if (requestStr == null || requestStr.isEmpty()) {
            throw new Exception("Invalid request data for writing into connection stream.");
        }
        byte[] dataBytes = requestStr.getBytes(RequestUtil.DEFAULT_TEXT_ENCODING);
        os.write(dataBytes);
    }
}

