/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Build.Writer;

import Zenoph.Notify.Build.Writer.DataWriter;
import Zenoph.Notify.Collections.ComposerDestinationsList;
import Zenoph.Notify.Compose.Composer;
import Zenoph.Notify.Compose.MessageComposer;
import Zenoph.Notify.Compose.SMSComposer;
import Zenoph.Notify.Compose.USSDComposer;
import Zenoph.Notify.Compose.VoiceComposer;
import Zenoph.Notify.Enums.ContentType;
import Zenoph.Notify.Enums.DestinationMode;
import Zenoph.Notify.Enums.MessageCategory;
import Zenoph.Notify.Store.ComposerDestination;
import Zenoph.Notify.Store.PersonalisedValues;
import Zenoph.Notify.Utils.RequestUtil;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public abstract class KeyValueDataWriter
extends DataWriter {
    static final String PSND_VALUES_UNIT_SEP = "__@";
    static final String PSND_VALUES_GRP_SEP = "__#";
    static final String DESTINATIONS_SEPARATOR = ",";

    protected abstract void appendKeyValueData(StringBuilder var1, String var2, String var3) throws Exception;

    @Override
    public void writeUSSDRequest(USSDComposer uc, OutputStream os) throws Exception {
    }

    private void writeUSSDData(SMSComposer tmc, StringBuilder strBuilder) throws Exception {
    }

    @Override
    public void writeSMSRequest(SMSComposer sc, OutputStream os) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.writeSMSProperties(sc, sb);
        this.writeCommonMessageProperties(sc, sb);
        this.writeDestinations(sc, sb);
        this.writeRequestData(sb.toString(), os);
    }

    private void writeSMSProperties(SMSComposer sc, StringBuilder sb) throws Exception {
        this.appendKeyValueData(sb, "text", sc.getMessage());
        this.appendKeyValueData(sb, "type", Integer.toString(sc.getSMSType().getId()));
        this.appendKeyValueData(sb, "sender", sc.getSender());
        if (sc.getMessageVariablesCount() > 0 && !sc.personalise()) {
            this.appendKeyValueData(sb, "personalise", "false");
        }
    }

    private void writeVoiceProperties(VoiceComposer vmc, StringBuilder sb) throws Exception {
        String sender = vmc.getSender();
        String tplRef = vmc.getTemplateReference();
        if (sender != null && !sender.isEmpty()) {
            this.appendKeyValueData(sb, "sender", sender);
        }
        if (tplRef != null && !tplRef.isEmpty()) {
            this.appendKeyValueData(sb, "template", tplRef);
        }
    }

    protected void writeVoiceMessageData(VoiceComposer vmc, StringBuilder sb) throws Exception {
        this.writeVoiceProperties(vmc, sb);
        this.writeCommonMessageProperties(vmc, sb);
        this.writeDestinations(vmc, sb);
    }

    @Override
    protected void writeCommonMessageProperties(MessageComposer mc, Object store) throws Exception {
        if (mc == null) {
            throw new Exception("Invalid reference to message object for writing common message properties.");
        }
        if (store == null || !(store instanceof StringBuilder)) {
            throw new Exception("Invalid reference to storage object for writing common message properties.");
        }
        if (mc instanceof MessageComposer && mc.schedule()) {
            Object[] scheduleInfo = mc.getScheduleInfo();
            this.writeScheduleInfo((Date)scheduleInfo[0], (String)scheduleInfo[1], (StringBuilder)store);
        }
        if (mc.notifyDeliveries()) {
            Object[] notifyInfo = mc.getDeliveryCallback();
            this.writeCallbackInfo((String)notifyInfo[0], (ContentType)((Object)notifyInfo[1]), (StringBuilder)store);
        }
    }

    @Override
    protected void writeScheduleInfo(Date dateTime, String utcOffset, Object store) throws Exception {
        this.validateScheduleInfo(dateTime, utcOffset);
        StringBuilder sb = (StringBuilder)store;
        this.appendKeyValueData(sb, "schedule", this.dateTimeToStr(dateTime));
        if (utcOffset != null && !utcOffset.isEmpty()) {
            this.appendKeyValueData(sb, "offset", utcOffset);
        }
    }

    @Override
    protected void writeCallbackInfo(String url, ContentType contentType, Object store) throws Exception {
        this.validateDeliveryNotificationInfo(url, contentType);
        StringBuilder sb = (StringBuilder)store;
        this.appendKeyValueData(sb, "callback_url", url);
        this.appendKeyValueData(sb, "callback_accept", RequestUtil.getDataContentTypeLabel(contentType));
    }

    @Override
    protected void writeDestinations(Composer mc, Object store) throws Exception {
        if (mc == null) {
            throw new Exception("Invalid reference to message object for writing destinations data.");
        }
        ComposerDestinationsList destsList = mc.getDestinations();
        if (destsList.getCount() == 0) {
            throw new Exception("There are no items to write message destinations data.");
        }
        String destsStr = "";
        String valuesStr = "";
        for (ComposerDestination cd : destsList) {
            if (cd.getWriteMode() == DestinationMode.DM_NONE) continue;
            String phoneNumber = cd.getPhoneNumber();
            if (mc instanceof MessageComposer) {
                ((MessageComposer)mc).validateDestinationSenderName(phoneNumber);
            }
            String messageId = cd.getMessageId();
            Object destData = cd.getData();
            String tempDestsStr = phoneNumber;
            if (messageId != null && !messageId.isEmpty()) {
                tempDestsStr = String.format("%s@%s", messageId, phoneNumber);
            }
            if (destData != null && destData instanceof PersonalisedValues) {
                String valStr = this.getPersonalisedValuesStr((PersonalisedValues)destData);
                valuesStr = valuesStr + String.format("%s%s", valuesStr.isEmpty() ? "" : PSND_VALUES_GRP_SEP, valStr);
            }
            destsStr = destsStr + String.format("%s%s", destsStr.isEmpty() ? "" : DESTINATIONS_SEPARATOR, tempDestsStr);
        }
        this.appendKeyValueData((StringBuilder)store, "to", destsStr);
        if (!valuesStr.isEmpty()) {
            this.appendKeyValueData((StringBuilder)store, "values", valuesStr);
        }
    }

    private String getPersonalisedValuesStr(PersonalisedValues pv) {
        String valStr = "";
        for (String value : pv.export()) {
            valStr = valStr + String.format("%s%s", valStr.isEmpty() ? "" : PSND_VALUES_UNIT_SEP, value);
        }
        return valStr;
    }

    private void writeMessageBatchId(String batchId, StringBuilder sb) throws Exception {
        this.appendKeyValueData(sb, "batch", batchId);
    }

    @Override
    public void writeDestinationsDeliveryRequest(List<String> messageIds, OutputStream os) throws Exception {
        if (messageIds == null || messageIds.isEmpty()) {
            throw new Exception("Invalid reference to list object for writing destinations delivery request.");
        }
        StringBuilder sb = new StringBuilder();
        String idsStr = "";
        for (String msgId : messageIds) {
            idsStr = idsStr + (!idsStr.isEmpty() ? DESTINATIONS_SEPARATOR : "") + msgId;
        }
        this.appendKeyValueData(sb, "to", idsStr);
        this.writeRequestData(sb.toString(), os);
    }

    @Override
    public void writeDestinationsData(Composer mc, OutputStream os) throws Exception {
        if (mc == null) {
            throw new Exception("Invalid reference to message object for writing destinations data.");
        }
        StringBuilder sb = new StringBuilder();
        this.writeDestinations(mc, sb);
        this.writeRequestData(sb.toString(), os);
    }

    @Override
    public void writeScheduledMessagesLoadRequest(HashMap<String, Object> data, OutputStream os) throws Exception {
        this.validateScheduledMessagesLoadData(data);
        StringBuilder sb = new StringBuilder();
        if (data.get("category") != null) {
            MessageCategory mcat = (MessageCategory)((Object)data.get("category"));
            this.appendKeyValueData(sb, "category", Integer.toString(mcat.getId()));
        }
        if (data.get("dateFrom") != null && data.get("dateTo") != null) {
            Date dateFrom = (Date)data.get("dateFrom");
            Date dateTo = (Date)data.get("dateTo");
            this.appendKeyValueData(sb, "from", this.dateTimeToStr(dateFrom));
            this.appendKeyValueData(sb, "to", this.dateTimeToStr(dateTo));
            if (data.get("offset") != null) {
                String utcOffset = data.get("offset").toString();
                this.appendKeyValueData(sb, "offset", utcOffset);
            }
        }
        this.writeRequestData(sb.toString(), os);
    }

    @Override
    public void writeScheduledMessageUpdateRequest(Composer mc, OutputStream os) throws Exception {
        if (mc == null) {
            throw new Exception("Invalid object reference for writing scheduled message update request.");
        }
        StringBuilder sb = new StringBuilder();
        MessageCategory category = mc.getCategory();
        if (category == MessageCategory.SMS || category == MessageCategory.USSD) {
            this.writeSMSProperties((SMSComposer)mc, sb);
        } else {
            this.writeVoiceProperties((VoiceComposer)mc, sb);
        }
        if (mc.getDestinationsCount() > 0) {
            this.writeScheduledMessageDestinations(mc, sb);
        }
        this.writeRequestData(sb.toString(), os);
    }

    private void writeScheduledMessageDestinations(Composer mc, StringBuilder sb) throws Exception {
        ComposerDestinationsList destsList = mc.getDestinations();
        if (destsList == null || destsList.isEmpty()) {
            return;
        }
        String delStr = "";
        String addStr = "";
        String addValues = "";
        String updateStr = "";
        String updateValues = "";
        for (ComposerDestination cd : destsList) {
            DestinationMode destMode = cd.getWriteMode();
            if (destMode == DestinationMode.DM_NONE) continue;
            String phoneNumber = cd.getPhoneNumber();
            ((MessageComposer)mc).validateDestinationSenderName(phoneNumber);
            String messageId = cd.getMessageId();
            Object destData = cd.getData();
            switch (destMode) {
                case DM_ADD: {
                    String tempStr = phoneNumber + (messageId == null ? "" : "@" + messageId);
                    addStr = addStr + String.format("%s%s", addStr.isEmpty() ? "" : DESTINATIONS_SEPARATOR, tempStr);
                    if (destData == null || !(destData instanceof PersonalisedValues)) break;
                    String valStr = this.getPersonalisedValuesStr((PersonalisedValues)destData);
                    addValues = addValues + String.format("%s%s", addValues.isEmpty() ? "" : PSND_VALUES_GRP_SEP, valStr);
                    break;
                }
                case DM_UPDATE: {
                    updateStr = updateStr + String.format("%s%s@%s", updateStr.isEmpty() ? "" : DESTINATIONS_SEPARATOR, messageId, phoneNumber);
                    if (destData == null || !(destData instanceof PersonalisedValues)) break;
                    String valStr = this.getPersonalisedValuesStr((PersonalisedValues)destData);
                    updateValues = updateValues + String.format("%s%s", updateValues.isEmpty() ? "" : PSND_VALUES_GRP_SEP, valStr);
                    break;
                }
                case DM_DELETE: {
                    if (messageId == null || messageId.isEmpty()) break;
                    delStr = delStr + String.format("%s%s", delStr.isEmpty() ? "" : DESTINATIONS_SEPARATOR, messageId);
                }
            }
        }
        if (!addStr.isEmpty()) {
            this.appendKeyValueData(sb, "to-add", addStr);
            if (!addValues.isEmpty()) {
                this.appendKeyValueData(sb, "values-add", addValues);
            }
        }
        if (!updateStr.isEmpty()) {
            this.appendKeyValueData(sb, "to-update", updateStr);
            if (!updateValues.isEmpty()) {
                this.appendKeyValueData(sb, "values-update", updateValues);
            }
        }
        if (!delStr.isEmpty()) {
            this.appendKeyValueData(sb, "to-delete", delStr);
        }
    }
}

