/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Collections;

import Zenoph.Notify.Collections.IDataList;
import Zenoph.Notify.Store.PersonalisedValues;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PersonalisedValuesList
implements IDataList,
Iterable<PersonalisedValues> {
    private List<PersonalisedValues> _valuesContainer = new ArrayList<PersonalisedValues>();

    @Override
    public void add(Object item) throws Exception {
        if (item == null || !(item instanceof PersonalisedValues)) {
            throw new Exception("Invalid reference to object for adding personalised values list item.");
        }
        this._valuesContainer.add((PersonalisedValues)item);
    }

    @Override
    public int getCount() {
        return this._valuesContainer.size();
    }

    @Override
    public Iterator<PersonalisedValues> iterator() {
        return this._valuesContainer.listIterator();
    }

    public String[] get(int idx) throws Exception {
        if (idx < 0 || idx > this._valuesContainer.size() - 1) {
            throw new Exception("Index out of range for getting personalised values.");
        }
        String[] values = this._valuesContainer.get(idx).export();
        String[] duplicate = new String[values.length];
        System.arraycopy(values, 0, duplicate, 0, values.length);
        return duplicate;
    }
}

