/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Compose;

import Zenoph.Notify.Collections.PersonalisedValuesList;
import Zenoph.Notify.Compose.ISMSComposer;
import Zenoph.Notify.Compose.MessageComposer;
import Zenoph.Notify.Enums.DestinationMode;
import Zenoph.Notify.Enums.MessageCategory;
import Zenoph.Notify.Enums.NumberAddInfo;
import Zenoph.Notify.Enums.SMSType;
import Zenoph.Notify.Store.AuthProfile;
import Zenoph.Notify.Store.ComposerDestination;
import Zenoph.Notify.Store.PersonalisedValues;
import Zenoph.Notify.Utils.MessageUtil;
import Zenoph.Notify.Utils.PhoneUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SMSComposer
extends MessageComposer
implements ISMSComposer {
    private boolean _personalise;
    private SMSType _type;
    private static final String VARS_PATTERN = MessageUtil.encodeString("\\{\\$[a-zA-Z_][a-zA-Z0-9]+\\}");
    public static final int NUMERIC_SENDER_MAX_LEN = 18;
    public static final int ALPHA_NUMERIC_SENDER_MAX_LEN = 11;

    public SMSComposer() {
        this._type = SMSType.GSM_DEFAULT;
        this._category = MessageCategory.SMS;
    }

    public SMSComposer(AuthProfile p) throws Exception {
        super(p);
        this._category = MessageCategory.SMS;
        this._type = p.getUserData().getDefaultTextMessageType();
    }

    public static SMSComposer create(Object obj) throws Exception {
        SMSComposer tm;
        if (obj == null || !(obj instanceof HashMap)) {
            throw new Exception("Invalid data for initialising SMS composer.");
        }
        HashMap param = (HashMap)obj;
        if (param == null) {
            throw new Exception("Invalid data for initialising text message composer.");
        }
        AuthProfile ap = null;
        String batchId = null;
        boolean isScheduled = false;
        if (param.containsKey("authProfile") && ((ap = (AuthProfile)param.get("authProfile")) == null || !(ap instanceof AuthProfile))) {
            throw new Exception("Invalid reference to authentication profile for initialising message composer.");
        }
        if (param.containsKey("batch")) {
            batchId = (String)param.get("batch");
            if (batchId == null || batchId.isEmpty()) {
                throw new Exception("Invalid message batch identifier for initialising SMS composer.");
            }
            if (!param.containsKey("category")) {
                throw new Exception("Missing message category specifier for initialising SMS composer.");
            }
        }
        if (param.containsKey("scheduled")) {
            isScheduled = (Boolean)param.get("scheduled");
        }
        SMSComposer sMSComposer = tm = ap == null ? new SMSComposer() : new SMSComposer(ap);
        if (batchId != null && !batchId.isEmpty()) {
            tm._batchId = batchId;
            tm._category = (MessageCategory)((Object)param.get("category"));
        }
        tm._isScheduled = isScheduled;
        return tm;
    }

    @Override
    public String[] getPersonalisedMessagePreview(String phoneNumber) throws Exception {
        this.validatePersonalisedMessagePreview(phoneNumber);
        PersonalisedValuesList pvl = this.getPersonalisedValues(phoneNumber);
        String[] messages = new String[pvl.getCount()];
        int idx = 0;
        for (PersonalisedValues pv : pvl) {
            messages[idx++] = this.getPersonalisedMessagePreview(phoneNumber, pv);
        }
        return messages;
    }

    @Override
    public String getPersonalisedMessagePreview(String phoneNumber, String[] values) throws Exception {
        this.validatePersonalisedMessagePreview(phoneNumber);
        if (!this.personalisedValuesExists(phoneNumber, values)) {
            throw new Exception("The specified personalised values do not exist.");
        }
        String[] variables = this.getMessageVariables(false);
        String preview = this._message;
        for (int i = 0; i < variables.length; ++i) {
            preview = preview.replace(variables[i], values[i]);
        }
        return preview;
    }

    @Override
    public String getPersonalisedMessagePreview(String phoneNumber, PersonalisedValues pv) throws Exception {
        return this.getPersonalisedMessagePreview(phoneNumber, pv.export());
    }

    @Override
    public int getMessageVariablesCount() throws Exception {
        return SMSComposer.getMessageVariablesCount(this._message);
    }

    private void validatePersonalisedMessagePreview(String phoneNumber) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            throw new Exception("Invalid phone number for message preview.");
        }
        if (!this.destinationExists(phoneNumber)) {
            throw new Exception(String.format("'%s' does not exist in destinations list.", phoneNumber));
        }
        if (!this.personalise()) {
            throw new Exception("Message is not personalised for generating preview.");
        }
    }

    public static int getMessageVariablesCount(String message) throws Exception {
        String[] varsList = SMSComposer.getMessageVariables(message);
        return varsList == null ? 0 : varsList.length;
    }

    @Override
    public int getMessageCount() throws Exception {
        return SMSComposer.getMessageCount(this._message, this._type);
    }

    public static int getMessageCount(String message, SMSType type) throws Exception {
        int messageLen;
        if (message == null || message.isEmpty()) {
            return 0;
        }
        HashMap<String, Object> typeInfo = MessageUtil.getMessageTypeInfo(type);
        if (typeInfo == null) {
            return -1;
        }
        int singleLen = Integer.parseInt(typeInfo.get("singleLen").toString());
        int concatLen = Integer.parseInt(typeInfo.get("concatLen").toString());
        int splitSize = messageLen > singleLen ? concatLen : singleLen;
        int messageCount = 1;
        for (int remainingLen = messageLen = message.length(); remainingLen > splitSize; remainingLen -= splitSize) {
            ++messageCount;
        }
        return messageCount;
    }

    @Override
    public String[] getMessageVariables() throws Exception {
        return SMSComposer.getMessageVariables(this._message, true);
    }

    @Override
    public String[] getMessageVariables(boolean trim) throws Exception {
        return SMSComposer.getMessageVariables(this._message, trim);
    }

    public static String[] getMessageVariables(String message) throws Exception {
        return SMSComposer.getMessageVariables(message, true);
    }

    public static String[] getMessageVariables(String message, boolean trim) throws Exception {
        if (message == null || message.isEmpty()) {
            return null;
        }
        ArrayList<String> varsList = new ArrayList<String>();
        Matcher m = Pattern.compile(MessageUtil.decodeString(VARS_PATTERN)).matcher(message);
        while (m.find()) {
            String name = m.group();
            if (trim) {
                name = SMSComposer.trimVariable(name);
            }
            varsList.add(name);
        }
        return varsList.toArray(new String[0]);
    }

    private static String trimVariable(String variable) throws Exception {
        if (variable == null || variable.isEmpty()) {
            throw new Exception("Invalid reference for trimming variable.");
        }
        String patt = "[\\{\\$\\}]";
        return variable.replaceAll(patt, "");
    }

    @Override
    public String[] getRegisteredSenderIds() throws Exception {
        if (this._userData == null) {
            return null;
        }
        HashMap<String, Object> sendersInfo = this._userData.getMessageSenders();
        String smsCategoryLabel = MessageUtil.getMessageCategoryLabel(MessageCategory.SMS);
        if (sendersInfo == null || sendersInfo.isEmpty()) {
            return null;
        }
        if (!sendersInfo.containsKey(smsCategoryLabel)) {
            return null;
        }
        return this.extractSenderIds((HashMap)sendersInfo.get(smsCategoryLabel));
    }

    private String[] extractSenderIds(HashMap<String, Object> sendersMap) {
        String[] senders = new String[sendersMap.size()];
        int idx = 0;
        for (Map.Entry<String, Object> entry : sendersMap.entrySet()) {
            senders[idx++] = entry.getKey();
        }
        return senders;
    }

    private NumberAddInfo assertPersonalisedValues(String phoneNumber, boolean throwEx, String[] values) throws Exception {
        if (values == null || values.length == 0) {
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_VALUES_EMPTY;
            }
            throw new Exception("Invalid reference to personalised values.");
        }
        if (this._message == null || this._message.isEmpty()) {
            throw new Exception("Message text has not been set for validating personalised values.");
        }
        String[] varsList = this.getMessageVariables();
        if (varsList == null || varsList.length != values.length) {
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_VALUES_COUNT;
            }
            throw new Exception("Mismatch variables and values count.");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null && !values[i].isEmpty()) continue;
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_VALUES_MISVAL;
            }
            String msg = "Missing or invalid personalised value at position " + (i + 1) + " for phone number '" + phoneNumber + "'.";
            throw new Exception(msg);
        }
        return NumberAddInfo.NAI_OK;
    }

    @Override
    public void setSender(String sender) throws Exception {
        if (sender == null || sender.isEmpty()) {
            throw new Exception("Invalid message sender text.");
        }
        if (PhoneUtil.isValidPhoneNumber(sender)) {
            if (sender.length() > NUMERIC_SENDER_MAX_LEN) {
                throw new Exception(String.format("Numeric message sender must not be more than %d characters.", NUMERIC_SENDER_MAX_LEN));
            }
        } else if (sender.length() > ALPHA_NUMERIC_SENDER_MAX_LEN) {
            throw new Exception(String.format("Alphanumeric message sender must not be more than %d characters.", ALPHA_NUMERIC_SENDER_MAX_LEN));
        }
        super.setSender(sender);
    }

    @Override
    public void setMessage(String message) throws Exception {
        this.setMessage(message, SMSComposer.getMessageVariablesCount(message) > 0);
    }

    @Override
    public void setMessage(String message, boolean personalise) throws Exception {
        if (message == null || message.isEmpty()) {
            throw new Exception("Invalid message text.");
        }
        int varsCount = SMSComposer.getMessageVariablesCount(message);
        if (personalise && varsCount == 0) {
            throw new Exception("Message does not contain variables for personalising.");
        }
        String currMessage = this.getMessage();
        if (currMessage != null && !currMessage.isEmpty()) {
            if (this.isScheduled()) {
                this.validateScheduledMessageTextUpdate(message, personalise);
            }
            if (personalise && !this.personalise() || !personalise && this.personalise()) {
                this.clearDestinations();
            }
        }
        this._message = message;
        this._personalise = personalise;
    }

    private void validateScheduledMessageTextUpdate(String newMessageText, boolean psn) throws Exception {
        int newMessageVarsCount;
        int schedMsgVarsCount;
        if (psn && !this.personalise()) {
            throw new Exception("Cannot replace non-personalised scheduled message with a personalised message.");
        }
        if (!psn && this.personalise()) {
            throw new Exception("Cannot replace a personalised scheduled message with non-personalised message.");
        }
        if (psn && this.personalise() && (schedMsgVarsCount = this.getMessageVariablesCount()) != (newMessageVarsCount = SMSComposer.getMessageVariablesCount(newMessageText))) {
            throw new Exception("Mismatch variables count in scheduled message text and replacement message text.");
        }
    }

    @Override
    public SMSType getDefaultSMSType() throws Exception {
        if (this._userData == null) {
            return null;
        }
        return this._userData.getDefaultTextMessageType();
    }

    @Override
    public void setSMSType(String type) throws Exception {
        if (this._userData == null) {
            throw new Exception("User data has not been loaded.");
        }
        this._type = MessageUtil.messageTypeToEnum(type);
    }

    @Override
    public void setSMSType(SMSType type) {
        this._type = type;
    }

    @Override
    public SMSType getSMSType() {
        return this._type;
    }

    public static List<SMSType> getSMSTypes() throws Exception {
        List<HashMap<String, Object>> loadedTypes = MessageUtil.getMessageTypes();
        ArrayList<SMSType> types = new ArrayList<SMSType>();
        if (loadedTypes != null) {
            for (HashMap<String, Object> item : loadedTypes) {
                types.add(SMSType.fromInt(Integer.parseInt(item.get("id").toString())));
            }
        } else {
            types.add(SMSType.GSM_DEFAULT);
            types.add(SMSType.UNICODE);
            types.add(SMSType.FLASH_GSM_DEFAULT);
            types.add(SMSType.FLASH_UNICODE);
        }
        return types;
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber) throws Exception {
        return this.addDestination(phoneNumber, true);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, String messageId) throws Exception {
        if (messageId == null || messageId.isEmpty()) {
            throw new Exception("Invalid custom message identifier for destination.");
        }
        return this.addDestination(phoneNumber, true, messageId);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, boolean throwEx) throws Exception {
        String messageId = null;
        return this.addDestination(phoneNumber, throwEx, messageId);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, boolean throwEx, String messageId) throws Exception {
        if (this._message != null && !this._message.isEmpty() && this.getMessageVariablesCount() > 0 && this._personalise) {
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_VALUES_EMPTY;
            }
            throw new Exception("Missing personalised values for destination.");
        }
        return super.addDestination(phoneNumber, throwEx, messageId);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, String[] values) throws Exception {
        return this.addDestination(phoneNumber, true, values);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, String[] values, String messageId) throws Exception {
        if (messageId == null || messageId.isEmpty()) {
            throw new Exception("Invalid custom message identifier for destination.");
        }
        this.validateCustomMessageId(messageId, true);
        return this.addDestination(phoneNumber, true, values, messageId);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, boolean throwEx, String[] values) throws Exception {
        return this.addDestination(phoneNumber, throwEx, values, null);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, boolean throwEx, String[] values, String messageId) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_INVALID;
            }
            throw new Exception("Invalid phone number for adding message destination.");
        }
        if (!PhoneUtil.isValidPhoneNumber(phoneNumber)) {
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_INVALID;
            }
            throw new Exception(String.format("'%s' is not a valid phone number.", phoneNumber));
        }
        if (!this.personalise()) {
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_NON_PSND;
            }
            throw new Exception("Cannot add values to non-personalised message.");
        }
        NumberAddInfo NAI = this.validateCustomMessageId(messageId, throwEx);
        if (NAI != NumberAddInfo.NAI_OK) {
            return NAI;
        }
        NAI = this.assertPersonalisedValues(phoneNumber, throwEx, values);
        if (NAI != NumberAddInfo.NAI_OK) {
            return NAI;
        }
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber);
        if (numberInfo == null) {
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_ROUTE;
            }
            throw new Exception(String.format("Phone number '%s' is invalid or not allowed on registered routes.", phoneNumber));
        }
        String fmtdNumber = numberInfo.get("number");
        String countryCode = numberInfo.get("countryCode");
        PersonalisedValuesList valuesContainer = this.getDestinationPersonalisedValues(fmtdNumber);
        if (valuesContainer != null && this.personalisedValuesExist(valuesContainer, values)) {
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_VALUES_EXIST;
            }
            throw new Exception(String.format("The personalised values already exist for destination '%s'.", fmtdNumber));
        }
        PersonalisedValues pv = new PersonalisedValues(values);
        return this.addDestination(fmtdNumber, countryCode, messageId, pv);
    }

    @Override
    public NumberAddInfo addPersonalisedDestination(String phoneNumber, String[] values) throws Exception {
        return this.addDestination(phoneNumber, values);
    }

    @Override
    public NumberAddInfo addPersonalisedDestination(String phoneNumber, String[] values, String messageId) throws Exception {
        return this.addDestination(phoneNumber, values, messageId);
    }

    @Override
    public NumberAddInfo addPersonalisedDestination(String phoneNumber, boolean throwEx, String[] values) throws Exception {
        return this.addDestination(phoneNumber, throwEx, values);
    }

    @Override
    public NumberAddInfo addPersonalisedDestination(String phoneNumber, boolean throwEx, String[] values, String messageId) throws Exception {
        return this.addDestination(phoneNumber, throwEx, values, messageId);
    }

    @Override
    public DestinationMode getDestinationWriteMode(String phoneNumber, String[] values) throws Exception {
        if (!this.personalise()) {
            throw new Exception("Message is not personalised for getting personalised destination mode.");
        }
        if (!this.destinationExists(phoneNumber)) {
            throw new Exception(String.format("Phone number '%s' does not exist in destinations list.", phoneNumber));
        }
        HashMap<String, String> numInfo = this.formatPhoneNumber(phoneNumber);
        String fmtdNumber = numInfo.get("number");
        List<ComposerDestination> compDestList = this.getMappedDestinations(fmtdNumber);
        for (ComposerDestination cd : compDestList) {
            PersonalisedValues pv = (PersonalisedValues)cd.getData();
            if (!this.stringifyPersonalisedValues(pv.export()).equals(this.stringifyPersonalisedValues(values))) continue;
            return cd.getWriteMode();
        }
        throw new Exception("The specified personalised values were not found for the destination.");
    }

    @Override
    public DestinationMode getPersonalisedDestinationWriteMode(String phoneNumber, String[] values) throws Exception {
        return this.getDestinationWriteMode(phoneNumber, values);
    }

    @Override
    public String getPersonalisedDestinationMessageId(String phoneNumber, String[] values) throws Exception {
        return this.getMessageId(phoneNumber, values);
    }

    @Override
    public String getMessageId(String phoneNumber, String[] values) throws Exception {
        if (!this.personalise()) {
            return super.getMessageId(phoneNumber);
        }
        if (values == null || values.length == 0) {
            throw new Exception("Invalid reference to values list for custom message identifier.");
        }
        List<ComposerDestination> destInfoList = this.getMappedDestinations(this.getFormattedPhoneNumber(phoneNumber));
        for (ComposerDestination destInfo : destInfoList) {
            PersonalisedValues pv = (PersonalisedValues)destInfo.getData();
            if (!this.stringifyPersonalisedValues(pv.export()).equals(this.stringifyPersonalisedValues(values))) continue;
            return destInfo.getMessageId();
        }
        throw new Exception("The specified personalised values were not found for the destination.");
    }

    private PersonalisedValuesList getDestinationPersonalisedValues(String phoneNumber) throws Exception {
        if (this.formattedDestinationExists(phoneNumber)) {
            List<ComposerDestination> destInfoList = this.getMappedDestinations(phoneNumber);
            PersonalisedValuesList pvl = new PersonalisedValuesList();
            for (ComposerDestination di : destInfoList) {
                PersonalisedValues pv = (PersonalisedValues)di.getData();
                pvl.add(pv);
            }
            return pvl;
        }
        return null;
    }

    @Override
    public PersonalisedValuesList getPersonalisedValues(String phoneNumber) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            throw new Exception("Invalid reference to phone number for personalised message values.");
        }
        if (!this.personalise()) {
            throw new Exception("Message is not personalised for getting destination personalised values.");
        }
        if (!this.destinationExists(phoneNumber)) {
            throw new Exception(String.format("Phone number '%s' does not exist for getting personalised values.", phoneNumber));
        }
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber);
        String fmtdNumber = numberInfo.get("number");
        return this.getDestinationPersonalisedValues(fmtdNumber);
    }

    @Override
    public String[] getPersonalisedValuesById(String messageId) throws Exception {
        if (messageId == null || messageId.isEmpty()) {
            throw new Exception("Invalid reference to message identifier for personalised message values.");
        }
        if (!this.messageIdExists(messageId)) {
            throw new Exception(String.format("Message identifier '%s' does not exist.", messageId));
        }
        ComposerDestination destInfo = this.getMappedDestinationById(messageId);
        PersonalisedValues pv = (PersonalisedValues)destInfo.getData();
        if (pv != null) {
            return pv.export();
        }
        return null;
    }

    private boolean personalisedValuesExist(PersonalisedValuesList valuesContainer, String[] values) throws Exception {
        if (valuesContainer != null) {
            for (PersonalisedValues pv : valuesContainer) {
                if (!String.join((CharSequence)",", pv.export()).equals(String.join((CharSequence)",", values))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean personalisedValuesExists(String phoneNumber, String[] values) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            throw new Exception("Invalid phone number for verifying personalised values.");
        }
        if (!this.destinationExists(phoneNumber)) {
            return false;
        }
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber);
        String fmtdNumber = numberInfo.get("number");
        this.assertPersonalisedValues(fmtdNumber, true, values);
        PersonalisedValuesList pvl = this.getPersonalisedValues(fmtdNumber);
        return this.personalisedValuesExist(pvl, values);
    }

    private void validatePersonalisedValuesForUpdate(String phoneNumber, String[] newValues, String[] preValues) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            throw new Exception("Invalid phone number for updating personalised message values.");
        }
        if (!this.personalise()) {
            throw new Exception("The message has not been personalised for updating values.");
        }
        if (!this.destinationExists(phoneNumber)) {
            throw new Exception(String.format("Phone number '%s' does not exist in the destinations list.", phoneNumber));
        }
        this.assertPersonalisedValues(phoneNumber, true, newValues);
        if (preValues != null) {
            this.assertPersonalisedValues(phoneNumber, true, preValues);
        }
    }

    @Override
    public boolean updatePersonalisedValuesById(String messageId, String[] newValues) throws Exception {
        if (messageId == null || messageId.isEmpty()) {
            throw new Exception("Invalid reference to message identifier for updating personalised message values.");
        }
        if (!this.messageIdExists(messageId)) {
            throw new Exception(String.format("Message identifier '%s' does not exist.", messageId));
        }
        ComposerDestination destInfo = this.getComposerDestinationById(messageId);
        PersonalisedValues pv = (PersonalisedValues)destInfo.getData();
        if (pv == null) {
            throw new Exception("The specified destination does not have personalised values for update.");
        }
        this.validatePersonalisedValuesForUpdate(destInfo.getPhoneNumber(), newValues, pv.export());
        return this.updatePersonalisedValues(destInfo, newValues);
    }

    @Override
    public boolean updatePersonalisedValues(String phoneNumber, String[] newValues) throws Exception {
        String[] preValues = null;
        return this.updatePersonalisedValues(phoneNumber, newValues, preValues);
    }

    @Override
    public boolean updatePersonalisedValues(String phoneNumber, String[] newValues, String messageId) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty() || !PhoneUtil.isValidPhoneNumber(phoneNumber)) {
            throw new Exception("Invalid phone number for updating personalised message values.");
        }
        if (messageId == null || messageId.isEmpty()) {
            throw new Exception("Invalid message identifier for updating personalised values.");
        }
        if (this.messageIdExists(messageId)) {
            throw new Exception(String.format("Message identifier '%s' already exists.", messageId));
        }
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber);
        String fmtdNumber = numberInfo.get("number");
        if (!this.formattedDestinationExists(phoneNumber)) {
            throw new Exception(String.format("Phone number '%s' does not exist for updating personalised values.", phoneNumber));
        }
        return this.replacePersonalisedValues(fmtdNumber, newValues, messageId);
    }

    @Override
    public boolean updatePersonalisedValues(String phoneNumber, String[] newValues, String[] preValues) throws Exception {
        this.validatePersonalisedValuesForUpdate(phoneNumber, newValues, preValues);
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber);
        String fmtdNumber = numberInfo.get("number");
        if (preValues == null) {
            return this.replacePersonalisedValues(fmtdNumber, newValues, null);
        }
        if (this.personalisedValuesExist(this.getPersonalisedValues(fmtdNumber), newValues)) {
            throw new Exception(String.format("The new personalised values already exist for destination '%s'.", fmtdNumber));
        }
        List<ComposerDestination> destInfoList = this.getComposerDestinations(fmtdNumber);
        for (ComposerDestination cd : destInfoList) {
            PersonalisedValues cpv = (PersonalisedValues)cd.getData();
            if (!this.stringifyPersonalisedValues(cpv.export()).equals(this.stringifyPersonalisedValues(preValues))) continue;
            return this.updatePersonalisedValues(cd, newValues);
        }
        return false;
    }

    private boolean updatePersonalisedValues(ComposerDestination cd, String[] values) throws Exception {
        boolean scheduled = cd.isScheduled();
        String messageId = cd.getMessageId();
        String phoneNumber = cd.getPhoneNumber();
        DestinationMode mode = scheduled ? DestinationMode.DM_UPDATE : cd.getWriteMode();
        PersonalisedValues npv = new PersonalisedValues(values);
        ComposerDestination newDestInfo = this.createComposerDestination(phoneNumber, messageId, mode, npv, scheduled);
        String countryCode = this.getDestinationCountryCode(phoneNumber);
        if (this.removeDestination(cd)) {
            this.addDestination(newDestInfo, countryCode);
            return true;
        }
        return false;
    }

    private boolean replacePersonalisedValues(String phoneNumber, String[] newValues, String messageId) throws Exception {
        if (!this.personalise()) {
            throw new Exception("Message is not personalised for updating values.");
        }
        this.validatePersonalisedValuesForUpdate(phoneNumber, newValues, null);
        String fmtdNumber = this.getFormattedPhoneNumber(phoneNumber);
        String countryCode = this.getDestinationCountryCode(fmtdNumber);
        List<ComposerDestination> destInfoList = this.getComposerDestinations(fmtdNumber);
        this.removeDestinationsList(fmtdNumber, destInfoList);
        DestinationMode destMode = DestinationMode.DM_ADD;
        PersonalisedValues pv = new PersonalisedValues(newValues);
        ComposerDestination compDest = this.createComposerDestination(fmtdNumber, messageId, destMode, pv);
        this.addDestination(compDest, countryCode);
        return true;
    }

    @Override
    public boolean removePersonalisedValues(String phoneNumber, String[] values) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            throw new Exception("Invalid reference to phone number for removing personalised values.");
        }
        if (!this.personalise()) {
            throw new Exception("Message has not been personalised for removing values.");
        }
        if (values == null || values.length == 0) {
            throw new Exception("Invalid reference to data for removing personalised values.");
        }
        if (!this.destinationExists(phoneNumber)) {
            return false;
        }
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber);
        String fmtdNumber = numberInfo.get("number");
        List<ComposerDestination> destInfoList = this.getMappedDestinations(fmtdNumber);
        String countryCode = this.getDestinationCountryCode(fmtdNumber);
        if (destInfoList.size() <= 1) {
            throw new Exception("Cannot remove personalised values for destination without multiple values.");
        }
        for (ComposerDestination compDest : destInfoList) {
            PersonalisedValues cpv = (PersonalisedValues)compDest.getData();
            if (!this.stringifyPersonalisedValues(cpv.export()).equals(this.stringifyPersonalisedValues(values))) continue;
            ComposerDestination replaceCompDest = null;
            if (compDest.isScheduled()) {
                String messageId = compDest.getMessageId();
                DestinationMode destMode = DestinationMode.DM_DELETE;
                replaceCompDest = this.createComposerDestination(fmtdNumber, messageId, destMode, cpv, true);
            }
            this.removeDestination(compDest);
            if (replaceCompDest != null) {
                this.addDestination(replaceCompDest, countryCode);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeDestination(String phoneNumber, String[] values) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            throw new Exception("Invalid phone number for removing message destination.");
        }
        if (values == null || values.length == 0) {
            throw new Exception("Invalid values for removing personalised message destination.");
        }
        if (!this.destinationExists(phoneNumber)) {
            throw new Exception(String.format("Phone number '%s' does not exist.", phoneNumber));
        }
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber);
        String fmtdNumber = numberInfo.get("number");
        List<ComposerDestination> mappedDests = this.getMappedDestinations(fmtdNumber);
        for (ComposerDestination compDest : mappedDests) {
            PersonalisedValues pv = (PersonalisedValues)compDest.getData();
            if (!this.stringifyPersonalisedValues(pv.export()).equals(this.stringifyPersonalisedValues(values))) continue;
            return this.removeDestination(compDest);
        }
        return false;
    }

    @Override
    public boolean removePersonalisedDestination(String phoneNumber, String[] values) throws Exception {
        return this.removeDestination(phoneNumber, values);
    }

    private String stringifyPersonalisedValues(String[] values) {
        return String.join((CharSequence)",", values);
    }

    @Override
    public boolean personalise() {
        return this._personalise;
    }
}

