/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Enums;

import java.util.HashMap;

public enum HTTPCode {
    OK(200),
    ERROR_BAD_REQUEST(400),
    ERROR_UNAUTHORIZED(401),
    ERROR_FORBIDDEN(403),
    ERROR_METHOD_NOT_ALLOWED(405),
    ERROR_NOT_ACCEPTABLE(406),
    ERROR_UNPROCESSABLE(422),
    ERROR_NOT_FOUND(404),
    ERROR_INTERNAL(500);

    int _id = 0;
    private static final HashMap<Integer, HTTPCode> _codeIntMap;

    private HTTPCode(int id) {
        this._id = id;
    }

    public int getId() {
        return this._id;
    }

    public static HTTPCode fromInt(int id) throws Exception {
        HTTPCode hc = _codeIntMap.get(id);
        if (hc == null) {
            throw new Exception("Invalid HTTP Code identifier.");
        }
        return hc;
    }

    static {
        _codeIntMap = new HashMap();
        for (HTTPCode hc : HTTPCode.values()) {
            _codeIntMap.put(hc.getId(), hc);
        }
    }
}

