/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Request;

import Zenoph.Notify.Build.Reader.MessagePropertiesReader;
import Zenoph.Notify.Build.Writer.DataWriter;
import Zenoph.Notify.Collections.MessageComposerList;
import Zenoph.Notify.Collections.MessageDestinationsList;
import Zenoph.Notify.Compose.MessageComposer;
import Zenoph.Notify.Compose.SMSComposer;
import Zenoph.Notify.Enums.ContentType;
import Zenoph.Notify.Enums.MessageCategory;
import Zenoph.Notify.Report.MessageReport;
import Zenoph.Notify.Request.NotifyRequest;
import Zenoph.Notify.Response.APIResponse;
import Zenoph.Notify.Response.MessageResponse;
import Zenoph.Notify.Store.AuthProfile;
import Zenoph.Notify.Utils.MessageUtil;
import java.util.Date;
import java.util.HashMap;

public class ScheduledMessageRequest
extends NotifyRequest {
    private static final String _baseResource = "message/scheduled";
    private MessageCategory _category;
    private String _batchId;
    private Date _fromDateTime = null;
    private Date _toDateTime = null;
    private String _utcOffset = null;

    public ScheduledMessageRequest() {
        this.init();
    }

    public ScheduledMessageRequest(AuthProfile p) throws Exception {
        super(p);
        this.init();
    }

    private void init() {
        this._category = MessageCategory.SMS;
    }

    private void validateDates() throws Exception {
        if (this._fromDateTime != null && this._toDateTime == null) {
            throw new Exception("'To Date' has not been set for scheduled messages request.");
        }
        if (this._fromDateTime == null && this._toDateTime != null) {
            throw new Exception("'From Date' has not been set for scheduled messages request.");
        }
    }

    private MessageComposerList createMessages(String dataFragment) throws Exception {
        if (dataFragment == null || dataFragment.isEmpty()) {
            return null;
        }
        if (!MessageResponse.isValidDataFragment(dataFragment)) {
            throw new Exception("Invalid response data fragment.");
        }
        MessagePropertiesReader reader = new MessagePropertiesReader();
        reader.setDataFragment(dataFragment);
        reader.isScheduled(true);
        if (this._authProfile != null) {
            reader.setAuthProfile(this._authProfile);
        }
        return reader.getMessages();
    }

    private HashMap<String, Object> prepareData() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("category", (Object)this._category);
        hm.put("dateFrom", this._fromDateTime);
        hm.put("dateTo", this._toDateTime);
        hm.put("offset", this._utcOffset);
        hm.put("batch", this._batchId);
        return hm;
    }

    private MessageComposerList loadScheduled() throws Exception {
        String resource = String.format("%s/load%s", _baseResource, this._batchId == null ? "" : "/" + this._batchId);
        this.setRequestResource(resource);
        this.setResponseContentType(ContentType.GZBIN_XML);
        this.initHttpRequest();
        if (this._batchId == null) {
            DataWriter dw = this.createDataWriter();
            dw.writeScheduledMessagesLoadRequest(this.prepareData(), this._httpConn.getOutputStream());
        }
        APIResponse apiResp = super.submit();
        return this.createMessages(apiResp.getDataFragment());
    }

    public MessageComposerList loadMessages(MessageCategory category) throws Exception {
        Date fromDate = null;
        Date toDate = null;
        return this.loadMessages(category, fromDate, toDate);
    }

    public MessageComposerList loadMessages(MessageCategory category, Date fromDateTime, Date toDateTime) throws Exception {
        return this.loadMessages(category, fromDateTime, toDateTime, null);
    }

    public MessageComposerList loadMessages(MessageCategory category, Date fromDate, Date toDate, String utcOffset) throws Exception {
        this._category = category;
        this._batchId = null;
        this._utcOffset = null;
        this._fromDateTime = fromDate;
        this._toDateTime = toDate;
        if (utcOffset != null && !utcOffset.isEmpty()) {
            if (!MessageUtil.isValidTimeZoneUTCOffset(utcOffset)) {
                throw new Exception("Invalid UTC offset for loading scheduled messages.");
            }
            this._utcOffset = utcOffset;
        }
        this.validateDates();
        return this.loadScheduled();
    }

    public MessageComposer loadMessage(String batchId) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new Exception("Invalid identifier for loading scheduled message.");
        }
        this._toDateTime = null;
        this._fromDateTime = null;
        this._batchId = batchId;
        MessageComposerList messages = this.loadScheduled();
        if (messages == null || messages.getCount() == 0) {
            return null;
        }
        return messages.get(0);
    }

    public int loadDestinations(MessageComposer message) throws Exception {
        String messageText;
        if (message == null) {
            throw new Exception("Invalid reference to message object for loading destinations.");
        }
        if (message instanceof SMSComposer && ((messageText = ((SMSComposer)message).getMessage()) == null || messageText.isEmpty())) {
            throw new Exception("Message text must be loaded before loading destinations for text messages.");
        }
        String batchId = message.getBatchId();
        if (batchId == null || batchId.isEmpty()) {
            throw new Exception("Invalid template identifier for loading scheduled message destinations.");
        }
        this._progressPercentage = 0;
        this.setRequestResource(String.format("%s/destinations/load/%s", _baseResource, batchId));
        this.setResponseContentType(ContentType.GZBIN_XML);
        this._progressPercentage = 100;
        this.updateRequestSubmitProgress();
        this.initHttpRequest();
        APIResponse apiResp = super.submit();
        return MessageComposer.populateScheduledDestinations(message, apiResp.getDataFragment());
    }

    public APIResponse cancelSchedule(MessageComposer mc) throws Exception {
        if (mc == null) {
            throw new Exception("Invalid message object reference for cancelling message scheduling.");
        }
        if (!mc.isScheduled()) {
            throw new Exception("The message has not been scheduled for cancelling.");
        }
        this.setRequestResource(String.format("%s/cancel/%s", _baseResource, mc.getBatchId()));
        this.initHttpRequest();
        return super.submit();
    }

    public APIResponse dispatchMessage(MessageComposer mc) throws Exception {
        if (mc == null) {
            throw new Exception("Invalid object reference for dispatching scheduled message.");
        }
        if (!mc.isScheduled()) {
            throw new Exception("Message has not been scheduled for dispatch.");
        }
        this.setRequestResource(String.format("%s/dispatch/%s", _baseResource, mc.getBatchId()));
        this.initHttpRequest();
        return super.submit();
    }

    public MessageResponse updateMessage(MessageComposer mc) throws Exception {
        if (mc == null) {
            throw new Exception("Invalid reference to message object for updating scheduled message.");
        }
        this.setRequestResource(String.format("%s/update/%s", _baseResource, mc.getBatchId()));
        this.setResponseContentType(ContentType.GZBIN_XML);
        this.initHttpRequest();
        DataWriter dw = this.createDataWriter();
        dw.writeScheduledMessageUpdateRequest(mc, this._httpConn.getOutputStream());
        this._progressPercentage = 60;
        this.updateRequestSubmitProgress();
        APIResponse apiResp = super.submit();
        this._progressPercentage = 100;
        this.updateRequestSubmitProgress();
        MessageResponse mr = MessageResponse.create(apiResp);
        MessageReport mRpt = mr.getReport();
        MessageDestinationsList msgDestsList = mRpt.getDestinations();
        if (msgDestsList != null && msgDestsList.getCount() > 0) {
            mc.refreshScheduledDestinationsUpdate(msgDestsList);
        }
        return mr;
    }
}

