/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Response;

import Zenoph.Notify.Enums.ContentType;
import Zenoph.Notify.Enums.RequestHandshake;
import Zenoph.Notify.Request.RequestException;
import Zenoph.Notify.Utils.Base64Util;
import Zenoph.Notify.Utils.RequestUtil;
import Zenoph.Notify.Utils.XMLUtil;
import java.io.ByteArrayInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class APIResponse {
    protected int _httpStatusCode = 0;
    protected String _dataFragment = "";
    protected RequestHandshake _requestHandShake;
    private static final String _responsePattern = "<response><handshake>.+<\\/handshake>(<data>(.*)<\\/data>)?<\\/response>";

    protected APIResponse() {
    }

    public static APIResponse create(Object[] params) throws Exception {
        int statusCode = Integer.parseInt(params[0].toString());
        String contentTypeLabel = params[1].toString();
        String responseData = params[2].toString();
        if (!RequestUtil.isValidContentTypeLabel(contentTypeLabel)) {
            throw new Exception("Unknown response content type label.");
        }
        ContentType contentType = RequestUtil.getDataContentTypeFromLabel(contentTypeLabel);
        if (contentType == ContentType.GZBIN_XML || contentType == ContentType.GZBIN_JSON || contentType == ContentType.GZBIN_WWW_URL_ENCODED) {
            byte[] respBytes = responseData.getBytes(RequestUtil.DEFAULT_TEXT_ENCODING);
            byte[] gzipBytes = Base64Util.decode(respBytes, 0, respBytes.length);
            if (gzipBytes == null) {
                throw new Exception("Invalid response data for submitted request.");
            }
            responseData = new String(RequestUtil.decompressData(gzipBytes).getBytes(), RequestUtil.DEFAULT_TEXT_ENCODING);
        }
        APIResponse ar = new APIResponse();
        ar.initResponse(statusCode, responseData);
        return ar;
    }

    private void initResponse(int httpCode, String responseStr) throws Exception {
        if (!this.isValidAPIResponse(responseStr)) {
            throw new Exception("Uknown response data was received from the server.");
        }
        this._httpStatusCode = httpCode;
        this.extractData(responseStr);
        this.assertRequestHandShake();
    }

    private boolean isValidAPIResponse(String responseStr) {
        Pattern p = Pattern.compile(_responsePattern, 32);
        Matcher m = p.matcher(responseStr);
        return m.find();
    }

    private void extractData(String responseStr) throws Exception {
        Pattern p = Pattern.compile(_responsePattern, 32);
        Matcher m = p.matcher(responseStr);
        String responseXml = null;
        if (m.find()) {
            responseXml = m.group();
        }
        if (responseXml == null) {
            throw new Exception("No response data pattern was matched.");
        }
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        ByteArrayInputStream is = new ByteArrayInputStream(responseXml.getBytes("UTF-8"));
        XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
        while (xmlReader.hasNext()) {
            int eventType = xmlReader.next();
            switch (eventType) {
                case 1: {
                    if (xmlReader.getLocalName().equalsIgnoreCase("handshake")) {
                        while (xmlReader.hasNext()) {
                            eventType = xmlReader.next();
                            boolean handShakeFound = false;
                            switch (eventType) {
                                case 1: {
                                    if (!xmlReader.getLocalName().equalsIgnoreCase("id")) break;
                                    this._requestHandShake = RequestHandshake.fromInt(Integer.parseInt(xmlReader.getElementText()));
                                    handShakeFound = true;
                                }
                            }
                            if (!handShakeFound) continue;
                            break;
                        }
                    }
                    if (!xmlReader.getLocalName().equalsIgnoreCase("data")) break;
                    this._dataFragment = XMLUtil.readNodeOuterXML(xmlReader, "data");
                }
            }
        }
    }

    private void assertRequestHandShake() throws Exception {
        if (this._requestHandShake != RequestHandshake.HSHK_OK) {
            String errStr = "Request handshake failure!";
            switch (this._requestHandShake) {
                case HSHK_ERR_RH_CONTENT_TYPE: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing or invalid request content type."), this._requestHandShake);
                }
                case HSHK_ERR_RH_HTTP_ACCEPT: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing or invalid response content type."), this._requestHandShake);
                }
                case HSHK_ERR_UA_AUTH: {
                    throw new RequestException(String.format("%s %s", errStr, "User authentication failed."), this._requestHandShake);
                }
                case HSHK_ERR_UA_MODEL: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing or invalid authentication model."), this._requestHandShake);
                }
                case HSHK_ERR_UA_PID: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing or invalid authentication PID."), this._requestHandShake);
                }
                case HSHK_ERR_UA_API_NO_ACCESS: {
                    throw new RequestException(String.format("%s %s", errStr, "API access is disabled in your account."), this._requestHandShake);
                }
                case HSHK_ERR_UA_API_NO_PPASS: {
                    throw new RequestException(String.format("%s %s", errStr, "Portal authentication factor is disabled over API calls."), this._requestHandShake);
                }
                case HSHK_ERR_DATA: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing request data."), this._requestHandShake);
                }
                case HSHK_ERR_BAD_REQUEST: {
                    throw new RequestException(String.format("%s %s", errStr, "Bad request."), this._requestHandShake);
                }
                case HSHK_ERR_INTERNAL: {
                    throw new RequestException(String.format("%s %s", errStr, "Internal server error."), this._requestHandShake);
                }
                case HSHK_ERR_ACCESS_DENIED: {
                    throw new RequestException(String.format("%s %s", errStr, "Access denied for request."), this._requestHandShake);
                }
                case HSHK_ERR_API_RETIRED: {
                    throw new RequestException(String.format("%s %s", errStr, "The API version for the request has been retired."), this._requestHandShake);
                }
                case HSHK_ERR_SERVICE: {
                    throw new RequestException(String.format("%s %s", errStr, "Service request not granted."), this._requestHandShake);
                }
                case HSHK_ERR_ACCT_INACTIVE: {
                    throw new RequestException(String.format("%s %s", errStr, "Account is currently inactive."), this._requestHandShake);
                }
                case HSHK_ERR_ACCT_SUSPENDED: {
                    throw new RequestException(String.format("%s %s", errStr, "Account is currently suspended."), this._requestHandShake);
                }
                case HSHK_ERR_IDEMPOTENCY_KEY: {
                    throw new RequestException(String.format("%s %s", errStr, "Invalid request idempotency key."), this._requestHandShake);
                }
                case HSHK_ERR_API_VERSION: {
                    throw new RequestException(String.format("%s %s", errStr, "Invalid request API version."), this._requestHandShake);
                }
                case HSHK_ERR_SM_PROCESSED: {
                    throw new RequestException(String.format("%s %s", errStr, "The scheduled message is already processed."), this._requestHandShake);
                }
                case HSHK_ERR_SM_CANCELLED: {
                    throw new RequestException(String.format("%s %s", errStr, "The scheduled message was cancelled."), this._requestHandShake);
                }
                case HSHK_ERR_SM_NOT_SCHEDULED: {
                    throw new RequestException(String.format("%s %s", errStr, "The specified message was not scheduled."), this._requestHandShake);
                }
                case HSHK_ERR_SM_REFERENCE_ID: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing or invalid message reference identifier."), this._requestHandShake);
                }
                case HSHK_ERR_SM_MESSAGE_ID: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing or invalid destination message identifier."), this._requestHandShake);
                }
                case HSHK_ERR_SM_CATEGORY: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing or invalid scheduled messages category."), this._requestHandShake);
                }
                case HSHK_ERR_SM_DATETIME: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing or invalid date and time filters for loading scheduled messages."), this._requestHandShake);
                }
                case HSHK_ERR_SM_UTC_OFFSET: {
                    throw new RequestException(String.format("%s %s", errStr, "Invalid UTC offset for message schedule time."), this._requestHandShake);
                }
                case HSHK_ERR_MR_BATCH_ID: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing or invalid message batch identifier for request."), this._requestHandShake);
                }
                case HSHK_ERR_MR_DESTINATIONS: {
                    throw new RequestException(String.format("%s %s", errStr, "Invalid message destinations parameter."), this._requestHandShake);
                }
                case HSHK_ERR_MR_PARAMETER: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing or invalid request parameter."), this._requestHandShake);
                }
                case HSHK_ERR_MR_QUERY_TIME: {
                    throw new RequestException(String.format("%s %s", errStr, "Message request time."), this._requestHandShake);
                }
                case HSHK_ERR_MR_VOICE_FILE: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing or invalid voice message file."), this._requestHandShake);
                }
                case HSHK_ERR_MR_VOICE_SIZE: {
                    throw new RequestException(String.format("%s %s", errStr, "Voice message file size limit exceeded."), this._requestHandShake);
                }
                case HSHK_ERR_MR_STATUS_FILTER: {
                    throw new RequestException(String.format("%s %s", errStr, "Missing or invalid message status filter."), this._requestHandShake);
                }
            }
            throw new RequestException(String.format("%s %s", errStr, "Unknown request handshake error."), this._requestHandShake);
        }
    }

    public String getDataFragment() {
        return this._dataFragment;
    }

    public int getHttpStatusCode() {
        return this._httpStatusCode;
    }

    public RequestHandshake getRequestHandShake() {
        return this._requestHandShake;
    }
}

