/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Response;

import Zenoph.Notify.Response.APIResponse;
import Zenoph.Notify.Utils.XMLUtil;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CreditBalanceResponse
extends APIResponse {
    private float _balance = 0.0f;
    private String _currencyName = null;
    private String _currencyCode = null;
    private boolean _isCurrencyModel = false;
    private static final String CURRENCY_CREDIT_MODEL = "currency";

    private CreditBalanceResponse() {
    }

    public static CreditBalanceResponse create(APIResponse apiResp) throws Exception {
        CreditBalanceResponse cbr = new CreditBalanceResponse();
        cbr._httpStatusCode = apiResp.getHttpStatusCode();
        cbr._requestHandShake = apiResp.getRequestHandShake();
        HashMap<String, Object> balanceInfo = CreditBalanceResponse.extractBalanceInfo(apiResp.getDataFragment());
        cbr._dataFragment = null;
        cbr._balance = Float.parseFloat(balanceInfo.get("balance").toString());
        cbr._isCurrencyModel = (Boolean)balanceInfo.get("isCurrencyModel");
        cbr._currencyName = cbr._isCurrencyModel ? balanceInfo.get("currencyName").toString() : null;
        cbr._currencyCode = cbr._isCurrencyModel ? balanceInfo.get("currencyCode").toString() : null;
        return cbr;
    }

    private static HashMap<String, Object> extractBalanceInfo(String dataFragment) throws Exception {
        Document xmlDoc = XMLUtil.createXMLDocument(dataFragment);
        XPath xpath = XPathFactory.newInstance().newXPath();
        HashMap<String, Object> balanceInfo = new HashMap<String, Object>();
        float balance = Float.parseFloat(((Node)xpath.compile("data/balance").evaluate(xmlDoc, XPathConstants.NODE)).getTextContent());
        boolean hasCurrencyCredit = ((Node)xpath.compile("data/model").evaluate(xmlDoc, XPathConstants.NODE)).getTextContent().equalsIgnoreCase(CURRENCY_CREDIT_MODEL);
        String currencyName = null;
        String currencyCode = null;
        if (hasCurrencyCredit) {
            currencyName = ((Node)xpath.compile("data/currencyName").evaluate(xmlDoc, XPathConstants.NODE)).getTextContent();
            currencyCode = ((Node)xpath.compile("data/currencyCode").evaluate(xmlDoc, XPathConstants.NODE)).getTextContent();
        }
        balanceInfo.put("balance", Float.valueOf(hasCurrencyCredit ? balance : (float)((int)balance)));
        balanceInfo.put("isCurrencyModel", hasCurrencyCredit);
        balanceInfo.put("currencyName", currencyName);
        balanceInfo.put("currencyCode", currencyCode);
        return balanceInfo;
    }

    public float getBalance() {
        return this._balance;
    }

    public String getCurrencyName() {
        return this._currencyName;
    }

    public String getCurrencyCode() {
        return this._currencyCode;
    }

    public boolean isCurrencyModel() {
        return this._isCurrencyModel;
    }
}

