/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Store;

import Zenoph.Notify.Enums.DestinationMode;
import java.util.HashMap;

public class ComposerDestination {
    private DestinationMode _destMode = DestinationMode.DM_NONE;
    private String _phoneNumber;
    private String _messageId;
    private Object _data;
    private boolean _scheduled = false;

    public static ComposerDestination create(Object data) throws Exception {
        if (data == null || !(data instanceof HashMap)) {
            throw new Exception("Invalid object reference for initialising composer destination.");
        }
        HashMap hm = (HashMap)data;
        if (hm == null) {
            throw new Exception("Invalid object reference for initialising composer destination.");
        }
        ComposerDestination.validateInitData(hm);
        ComposerDestination cd = new ComposerDestination();
        cd._destMode = (DestinationMode)((Object)hm.get("destMode"));
        cd._phoneNumber = (String)hm.get("phoneNumber");
        cd._messageId = (String)hm.get("messageId");
        cd._data = hm.get("data");
        cd._scheduled = (Boolean)hm.get("scheduled");
        return cd;
    }

    private static void validateInitData(HashMap<String, Object> data) throws Exception {
        if (!data.containsKey("destMode")) {
            throw new Exception("Destination mode specifier not set.");
        }
        if (!data.containsKey("phoneNumber")) {
            throw new Exception("Phone number not specified for composer destination.");
        }
        if (!data.containsKey("messageId")) {
            throw new Exception("Message identifier not specified for composer destination.");
        }
        if (!data.containsKey("data")) {
            throw new Exception("Data not specified for composer destination.");
        }
        if (!data.containsKey("scheduled")) {
            throw new Exception("Destination schedule specifier has not been set.");
        }
        DestinationMode mode = (DestinationMode)((Object)data.get("destMode"));
        String phoneNumber = (String)data.get("phoneNumber");
        String messageId = (String)data.get("messageId");
        if (mode == null) {
            throw new Exception("Invalid destination mode for composer destination.");
        }
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            throw new Exception("Invalid phone number for composer destination.");
        }
        if (messageId != null && messageId.isEmpty()) {
            throw new Exception("Invalid message identifier for composer destination.");
        }
    }

    public void reset() throws Exception {
        if (!this._scheduled) {
            throw new Exception("Cannot reset write mode for non-scheduled destination.");
        }
        this._destMode = DestinationMode.DM_NONE;
    }

    public String getPhoneNumber() {
        return this._phoneNumber;
    }

    public String getMessageId() {
        return this._messageId;
    }

    public DestinationMode getWriteMode() {
        return this._destMode;
    }

    public Object getData() {
        return this._data;
    }

    public boolean isScheduled() {
        return this._scheduled;
    }
}

