/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Utils;

import Zenoph.Notify.Utils.MessageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhoneUtil {
    public static final String PHONE_NUMBER_PATTERN = "\\+?[0-9]{8,13}";

    public static boolean isValidPhoneNumber(String str) {
        return MessageUtil.isRegexMatch(String.format("%s%s%s", "^", PHONE_NUMBER_PATTERN, "$"), str);
    }

    public static List<String> extractPhoneNumbers(String str) throws Exception {
        if (str == null || str.isEmpty()) {
            throw new Exception("Invalid reference to text stream for extracting phone numbers.");
        }
        ArrayList<String> validList = null;
        Matcher m = Pattern.compile(MessageUtil.decodeString(PHONE_NUMBER_PATTERN)).matcher(str);
        while (m.find()) {
            if (validList == null) {
                validList = new ArrayList<String>();
            }
            validList.add(m.group());
        }
        return validList;
    }

    public static String stripPhoneNumberPrefixes(String phonenum) {
        if ((phonenum = phonenum.replaceAll("[^\\d]", "")).substring(0, 2).equals("00")) {
            phonenum = phonenum.substring(2);
        } else if (phonenum.substring(0, 1).equals("0")) {
            phonenum = phonenum.substring(1);
        }
        return phonenum;
    }
}

