/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Utils;

import Zenoph.Notify.Enums.ContentType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class RequestUtil {
    public static final String DEFAULT_TEXT_ENCODING = "UTF-8";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DCTL_APPLICATION_XML = "application/xml";
    private static final String DCTL_APPLICATION_GZBIN_XML;
    private static final String DCTL_APPLICATION_JSON;
    private static final String DCTL_APPLICATION_GZBIN_JSON;
    private static final String DCTL_APPLICATION_URL_ENCODED;
    private static final String DCTL_APPLICATION_GZBIN_URL_ENCODED;
    private static final String DCTL_MULTIPART_FORM_DATA;

    public static boolean isValidContentTypeLabel(String label) throws Exception {
        if (label == null || label.isEmpty()) {
            throw new Exception("Invalid content type label for validation.");
        }
        return label.equalsIgnoreCase(DCTL_APPLICATION_XML) || label.equalsIgnoreCase(DCTL_APPLICATION_JSON) || label.equalsIgnoreCase(DCTL_MULTIPART_FORM_DATA) || label.equalsIgnoreCase(DCTL_APPLICATION_URL_ENCODED) || label.equalsIgnoreCase(DCTL_APPLICATION_GZBIN_XML) || label.equalsIgnoreCase(DCTL_APPLICATION_GZBIN_JSON) || label.equalsIgnoreCase(DCTL_APPLICATION_GZBIN_URL_ENCODED);
    }

    public static String getDataContentTypeLabel(ContentType dct) throws Exception {
        switch (dct) {
            case XML: {
                return DCTL_APPLICATION_XML;
            }
            case GZBIN_XML: {
                return DCTL_APPLICATION_GZBIN_XML;
            }
            case JSON: {
                return DCTL_APPLICATION_JSON;
            }
            case GZBIN_JSON: {
                return DCTL_APPLICATION_GZBIN_JSON;
            }
            case WWW_URL_ENCODED: {
                return DCTL_APPLICATION_URL_ENCODED;
            }
            case GZBIN_WWW_URL_ENCODED: {
                return DCTL_APPLICATION_GZBIN_URL_ENCODED;
            }
            case MULTIPART_FORM_DATA: {
                return DCTL_MULTIPART_FORM_DATA;
            }
        }
        throw new Exception("Unknown data content type for label.");
    }

    public static ContentType getDataContentTypeFromLabel(String typeLabel) throws Exception {
        if (typeLabel.equalsIgnoreCase(DCTL_APPLICATION_XML)) {
            return ContentType.XML;
        }
        if (typeLabel.equalsIgnoreCase(DCTL_APPLICATION_GZBIN_XML)) {
            return ContentType.GZBIN_XML;
        }
        if (typeLabel.equalsIgnoreCase(DCTL_APPLICATION_JSON)) {
            return ContentType.JSON;
        }
        if (typeLabel.equalsIgnoreCase(DCTL_APPLICATION_GZBIN_JSON)) {
            return ContentType.GZBIN_JSON;
        }
        if (typeLabel.equalsIgnoreCase(DCTL_APPLICATION_URL_ENCODED)) {
            return ContentType.WWW_URL_ENCODED;
        }
        if (typeLabel.equalsIgnoreCase(DCTL_APPLICATION_GZBIN_URL_ENCODED)) {
            return ContentType.GZBIN_WWW_URL_ENCODED;
        }
        if (typeLabel.equals(DCTL_MULTIPART_FORM_DATA)) {
            return ContentType.MULTIPART_FORM_DATA;
        }
        throw new Exception("Unknown label for data content type.");
    }

    public static String compressData(String str) throws Exception {
        if (str == null || str.isEmpty()) {
            throw new Exception("Empty data for GZip compression.");
        }
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        GZIPOutputStream gzs = new GZIPOutputStream(bas);
        gzs.write(str.getBytes("UTF-8"));
        gzs.flush();
        gzs.close();
        return new String(bas.toByteArray(), DEFAULT_TEXT_ENCODING);
    }

    public static String decompressData(byte[] gzBytes) throws Exception {
        String line;
        if (gzBytes == null) {
            throw new Exception("Invalid reference for decompressing GZip data.");
        }
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(gzBytes));
        BufferedReader bf = new BufferedReader(new InputStreamReader(gis));
        String str = "";
        while ((line = bf.readLine()) != null) {
            str = str + line;
        }
        return str;
    }

    static {
        DCTL_APPLICATION_JSON = "application/json";
        DCTL_MULTIPART_FORM_DATA = "multipart/form-data";
        DCTL_APPLICATION_URL_ENCODED = "application/x-www-form-urlencoded";
        DCTL_APPLICATION_GZBIN_XML = "application/vnd.zenoph.zbm.gzbin+xml";
        DCTL_APPLICATION_GZBIN_JSON = "application/vnd.zenoph.zbm.gzbin+json";
        DCTL_APPLICATION_GZBIN_URL_ENCODED = "application/vnd.zenoph.zbm.gzbin+urlencoded";
    }
}

